@block @block_quickmail @ferpa @javascript
Feature: Ensure enrollee visibility behaves in accordance with ferpa settings.




#/var/www/jpeak5.mdl/blocks/quickmail/tests/behat/ferpa.feature

# Tests that the visibility of students/teachers enrolled in a course adheres to the FERPA controls and the
# Student usage controls available at the block and admin level.

# A set of 25 scenarios.
# These scenarios cover a minimal set of
# the possible configurations for quickmail. Given 2 administrative settings with 3 options each, and 2 block-level
# settings with 2 and 3 options each, there are a total of 3*3*3*2=54 configuration combinations.
# Because settings at the administrative level override those at the block level, 29 of those can be removed,
# leaving the 25 given in the test.

# NB: Because of the additional complexity, the /var/www/jpeak5.mdl/blocks/quickmail/tests/behat/ferpa.feature test does not account for the groups filter.

Background:
    Given the following "courses" exist:
        |fullname|shortname|category|
        |Course One| C1|0|
#    And the following "users" exist:
#        |username|firstname|lastname|
#        |t1|t1|teacher|
#        |t4|t4|editingteacher|
#        |s1|s1|student|
#        |s4|s4|student|
#        |t2|t2|teacher|
#        |s2|s2|student|
#        |t3|t3|teacher|
#        |s3|s3|student|
#        |t5|t5|teacher|
#        |s5|s5|student|
    And the following "course enrolments" exist:
        |user|course|role|
        |t1| C1|teacher|
        |t4| C1|editingteacher|
        |s1| C1|student|
        |s4| C1|student|
        |t2| C1|teacher|
        |s2| C1|student|
        |t3| C1|teacher|
        |s3| C1|student|
        |t5| C1|teacher|
        |s5| C1|student|
    And the following "groups" exist:
        |name|course|idnumber|
        |group1| C1|group1|
        |group2| C1|group2|
        |group3| C1|group3|
    And the following "group members" exist:
        |user|group|
        |t1|group1|
        |t4|group1|
        |t4|group2|
        |t4|group3|
        |s1|group1|
        |s4|group1|
        |s4|group2|
        |t2|group2|
        |s2|group2|
        |t3|group3|
        |s3|group3|
    Given I log in as "admin"
        And I navigate to "Define roles" node in "Site administration > Users > Permissions"
        And I click on "Edit" "link" in the "Non-editing teacher" "table_row"
        And I click on "Allow" "checkbox" in the "Access all groups" "table_row"
        And I press "Save changes"
        And I log out

    Given I log in as "t4"
        And I follow "Course One"
        And I turn editing mode on
        And I add the "Quickmail" block
        And I should see "Compose New Email" in the "Quickmail" "block"
        And I log out

# Configuration details:
# Allow students to use Quickmail [global]: Yes
# Allow students to use Quickmail [course]: Yes
# FERPA Mode: Always Separate Groups
# Course group mode: ignored

Scenario: 25

        And I log in as "t1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group1)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1)" in the "#from_users" "css_element"
            Then I should not see "t2 teacher" in the "#from_users" "css_element"
            Then I should not see "s2 student" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            Then I should not see "group2" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "t4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1)" in the "#from_users" "css_element"
            Then I should not see "t2 teacher" in the "#from_users" "css_element"
            Then I should not see "s2 student" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            Then I should not see "group2" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group1,group2)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            Then I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "t2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "s4 student (group2)" in the "#from_users" "css_element"
            Then I should not see "t1 teacher" in the "#from_users" "css_element"
            Then I should not see "s1 student" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group2)" in the "#from_users" "css_element"
            Then I should see "s4 student (group2)" in the "#from_users" "css_element"
            Then I should not see "t1 teacher" in the "#from_users" "css_element"
            Then I should not see "s1 student" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "t3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should not see "t1 teacher" in the "#from_users" "css_element"
            Then I should not see "s1 student" in the "#from_users" "css_element"
            Then I should not see "s4 student" in the "#from_users" "css_element"
            Then I should not see "t2 teacher" in the "#from_users" "css_element"
            Then I should not see "s2 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group2" in the "#groups" "css_element"
        And I log out

        And I log in as "s3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group3)" in the "#from_users" "css_element"
            Then I should not see "t1 teacher" in the "#from_users" "css_element"
            Then I should not see "s1 student" in the "#from_users" "css_element"
            Then I should not see "s4 student" in the "#from_users" "css_element"
            Then I should not see "t2 teacher" in the "#from_users" "css_element"
            Then I should not see "s2 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group2" in the "#groups" "css_element"
        And I log out

        And I log in as "t5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group2" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group2" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

# Configuration details:
# Allow students to use Quickmail [global]: Yes
# Allow students to use Quickmail [course]: not set
# FERPA Mode: Always Separate Groups
# Course group mode: ignored

Scenario: 26

        And I log in as "t1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group1)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1)" in the "#from_users" "css_element"
            Then I should not see "t2 teacher" in the "#from_users" "css_element"
            Then I should not see "s2 student" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            Then I should not see "group2" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "t4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s1"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "s4"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "s4 student (group2)" in the "#from_users" "css_element"
            Then I should not see "t1 teacher" in the "#from_users" "css_element"
            Then I should not see "s1 student" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s2"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should not see "t1 teacher" in the "#from_users" "css_element"
            Then I should not see "s1 student" in the "#from_users" "css_element"
            Then I should not see "s4 student" in the "#from_users" "css_element"
            Then I should not see "t2 teacher" in the "#from_users" "css_element"
            Then I should not see "s2 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group2" in the "#groups" "css_element"
        And I log out

        And I log in as "s3"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group2" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s5"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

# Configuration details:
# Allow students to use Quickmail [global]: Yes
# Allow students to use Quickmail [course]: Yes
# FERPA Mode: not set
# Course group mode: not set

Scenario: 27

        And I log in as "t1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

# Configuration details:
# Allow students to use Quickmail [global]: Yes
# Allow students to use Quickmail [course]: not set
# FERPA Mode: not set
# Course group mode: not set

Scenario: 28

        And I log in as "t1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s1"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "s4"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s2"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s3"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s5"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

# Configuration details:
# Allow students to use Quickmail [global]: Yes
# Allow students to use Quickmail [course]: Yes
# FERPA Mode: not set
# Course group mode: Separate groups

Scenario: 29

        And I log in as "t1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group1)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1)" in the "#from_users" "css_element"
            Then I should not see "t2 teacher" in the "#from_users" "css_element"
            Then I should not see "s2 student" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            Then I should not see "group2" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "t4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1)" in the "#from_users" "css_element"
            Then I should not see "t2 teacher" in the "#from_users" "css_element"
            Then I should not see "s2 student" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            Then I should not see "group2" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group1,group2)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            Then I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "t2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "s4 student (group2)" in the "#from_users" "css_element"
            Then I should not see "t1 teacher" in the "#from_users" "css_element"
            Then I should not see "s1 student" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group2)" in the "#from_users" "css_element"
            Then I should see "s4 student (group2)" in the "#from_users" "css_element"
            Then I should not see "t1 teacher" in the "#from_users" "css_element"
            Then I should not see "s1 student" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "t3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should not see "t1 teacher" in the "#from_users" "css_element"
            Then I should not see "s1 student" in the "#from_users" "css_element"
            Then I should not see "s4 student" in the "#from_users" "css_element"
            Then I should not see "t2 teacher" in the "#from_users" "css_element"
            Then I should not see "s2 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group2" in the "#groups" "css_element"
        And I log out

        And I log in as "s3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group3)" in the "#from_users" "css_element"
            Then I should not see "t1 teacher" in the "#from_users" "css_element"
            Then I should not see "s1 student" in the "#from_users" "css_element"
            Then I should not see "s4 student" in the "#from_users" "css_element"
            Then I should not see "t2 teacher" in the "#from_users" "css_element"
            Then I should not see "s2 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group2" in the "#groups" "css_element"
        And I log out

        And I log in as "t5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group2" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group2" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

# Configuration details:
# Allow students to use Quickmail [global]: Yes
# Allow students to use Quickmail [course]: not set
# FERPA Mode: not set
# Course group mode: Separate groups

Scenario: 30

        And I log in as "t1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group1)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1)" in the "#from_users" "css_element"
            Then I should not see "t2 teacher" in the "#from_users" "css_element"
            Then I should not see "s2 student" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            Then I should not see "group2" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "t4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s1"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "s4"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "s4 student (group2)" in the "#from_users" "css_element"
            Then I should not see "t1 teacher" in the "#from_users" "css_element"
            Then I should not see "s1 student" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s2"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should not see "t1 teacher" in the "#from_users" "css_element"
            Then I should not see "s1 student" in the "#from_users" "css_element"
            Then I should not see "s4 student" in the "#from_users" "css_element"
            Then I should not see "t2 teacher" in the "#from_users" "css_element"
            Then I should not see "s2 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group2" in the "#groups" "css_element"
        And I log out

        And I log in as "s3"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group2" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s5"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

# Configuration details:
# Allow students to use Quickmail [global]: Yes
# Allow students to use Quickmail [course]: Yes
# FERPA Mode: not set
# Course group mode: Visible groups

Scenario: 31

        And I log in as "t1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group1,group2,group3)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group1,group2,group3)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group1,group2,group3)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group1,group2,group3)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group1,group2,group3)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group1,group2,group3)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group1,group2,group3)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

# Configuration details:
# Allow students to use Quickmail [global]: Yes
# Allow students to use Quickmail [course]: not set
# FERPA Mode: not set
# Course group mode: Visible groups

Scenario: 32

        And I log in as "t1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group1,group2,group3)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s1"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "s4"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group1,group2,group3)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s2"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group1,group2,group3)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s3"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s5"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

# Configuration details:
# Allow students to use Quickmail [global]: Yes
# Allow students to use Quickmail [course]: Yes
# FERPA Mode: No Group Respect
# Course group mode: ignored

Scenario: 33

        And I log in as "t1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

# Configuration details:
# Allow students to use Quickmail [global]: Yes
# Allow students to use Quickmail [course]: not set
# FERPA Mode: No Group Respect
# Course group mode: ignored

Scenario: 34

        And I log in as "t1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s1"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "s4"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s2"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s3"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s5"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

# Configuration details:
# Allow students to use Quickmail [global]: not set
# Allow students to use Quickmail [course]: Yes
# FERPA Mode: Always Separate Groups
# Course group mode: ignored

Scenario: 35

        And I log in as "t1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group1)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1)" in the "#from_users" "css_element"
            Then I should not see "t2 teacher" in the "#from_users" "css_element"
            Then I should not see "s2 student" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            Then I should not see "group2" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "t4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1)" in the "#from_users" "css_element"
            Then I should not see "t2 teacher" in the "#from_users" "css_element"
            Then I should not see "s2 student" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            Then I should not see "group2" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group1,group2)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            Then I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "t2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "s4 student (group2)" in the "#from_users" "css_element"
            Then I should not see "t1 teacher" in the "#from_users" "css_element"
            Then I should not see "s1 student" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group2)" in the "#from_users" "css_element"
            Then I should see "s4 student (group2)" in the "#from_users" "css_element"
            Then I should not see "t1 teacher" in the "#from_users" "css_element"
            Then I should not see "s1 student" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "t3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should not see "t1 teacher" in the "#from_users" "css_element"
            Then I should not see "s1 student" in the "#from_users" "css_element"
            Then I should not see "s4 student" in the "#from_users" "css_element"
            Then I should not see "t2 teacher" in the "#from_users" "css_element"
            Then I should not see "s2 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group2" in the "#groups" "css_element"
        And I log out

        And I log in as "s3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group3)" in the "#from_users" "css_element"
            Then I should not see "t1 teacher" in the "#from_users" "css_element"
            Then I should not see "s1 student" in the "#from_users" "css_element"
            Then I should not see "s4 student" in the "#from_users" "css_element"
            Then I should not see "t2 teacher" in the "#from_users" "css_element"
            Then I should not see "s2 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group2" in the "#groups" "css_element"
        And I log out

        And I log in as "t5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group2" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group2" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

# Configuration details:
# Allow students to use Quickmail [global]: not set
# Allow students to use Quickmail [course]: not set
# FERPA Mode: Always Separate Groups
# Course group mode: ignored

Scenario: 36

        And I log in as "t1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group1)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1)" in the "#from_users" "css_element"
            Then I should not see "t2 teacher" in the "#from_users" "css_element"
            Then I should not see "s2 student" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            Then I should not see "group2" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "t4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s1"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "s4"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "s4 student (group2)" in the "#from_users" "css_element"
            Then I should not see "t1 teacher" in the "#from_users" "css_element"
            Then I should not see "s1 student" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s2"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should not see "t1 teacher" in the "#from_users" "css_element"
            Then I should not see "s1 student" in the "#from_users" "css_element"
            Then I should not see "s4 student" in the "#from_users" "css_element"
            Then I should not see "t2 teacher" in the "#from_users" "css_element"
            Then I should not see "s2 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group2" in the "#groups" "css_element"
        And I log out

        And I log in as "s3"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group2" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s5"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

# Configuration details:
# Allow students to use Quickmail [global]: not set
# Allow students to use Quickmail [course]: Yes
# FERPA Mode: not set
# Course group mode: not set

Scenario: 37

        And I log in as "t1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

# Configuration details:
# Allow students to use Quickmail [global]: not set
# Allow students to use Quickmail [course]: not set
# FERPA Mode: not set
# Course group mode: not set

Scenario: 38

        And I log in as "t1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s1"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "s4"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s2"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s3"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s5"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

# Configuration details:
# Allow students to use Quickmail [global]: not set
# Allow students to use Quickmail [course]: Yes
# FERPA Mode: not set
# Course group mode: Separate groups

Scenario: 39

        And I log in as "t1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group1)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1)" in the "#from_users" "css_element"
            Then I should not see "t2 teacher" in the "#from_users" "css_element"
            Then I should not see "s2 student" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            Then I should not see "group2" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "t4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1)" in the "#from_users" "css_element"
            Then I should not see "t2 teacher" in the "#from_users" "css_element"
            Then I should not see "s2 student" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            Then I should not see "group2" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group1,group2)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            Then I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "t2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "s4 student (group2)" in the "#from_users" "css_element"
            Then I should not see "t1 teacher" in the "#from_users" "css_element"
            Then I should not see "s1 student" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group2)" in the "#from_users" "css_element"
            Then I should see "s4 student (group2)" in the "#from_users" "css_element"
            Then I should not see "t1 teacher" in the "#from_users" "css_element"
            Then I should not see "s1 student" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "t3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should not see "t1 teacher" in the "#from_users" "css_element"
            Then I should not see "s1 student" in the "#from_users" "css_element"
            Then I should not see "s4 student" in the "#from_users" "css_element"
            Then I should not see "t2 teacher" in the "#from_users" "css_element"
            Then I should not see "s2 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group2" in the "#groups" "css_element"
        And I log out

        And I log in as "s3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group3)" in the "#from_users" "css_element"
            Then I should not see "t1 teacher" in the "#from_users" "css_element"
            Then I should not see "s1 student" in the "#from_users" "css_element"
            Then I should not see "s4 student" in the "#from_users" "css_element"
            Then I should not see "t2 teacher" in the "#from_users" "css_element"
            Then I should not see "s2 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group2" in the "#groups" "css_element"
        And I log out

        And I log in as "t5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group2" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group2" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

# Configuration details:
# Allow students to use Quickmail [global]: not set
# Allow students to use Quickmail [course]: not set
# FERPA Mode: not set
# Course group mode: Separate groups

Scenario: 40

        And I log in as "t1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group1)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1)" in the "#from_users" "css_element"
            Then I should not see "t2 teacher" in the "#from_users" "css_element"
            Then I should not see "s2 student" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            Then I should not see "group2" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "t4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s1"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "s4"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "s4 student (group2)" in the "#from_users" "css_element"
            Then I should not see "t1 teacher" in the "#from_users" "css_element"
            Then I should not see "s1 student" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s2"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should not see "t1 teacher" in the "#from_users" "css_element"
            Then I should not see "s1 student" in the "#from_users" "css_element"
            Then I should not see "s4 student" in the "#from_users" "css_element"
            Then I should not see "t2 teacher" in the "#from_users" "css_element"
            Then I should not see "s2 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group2" in the "#groups" "css_element"
        And I log out

        And I log in as "s3"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group2" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s5"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

# Configuration details:
# Allow students to use Quickmail [global]: not set
# Allow students to use Quickmail [course]: Yes
# FERPA Mode: not set
# Course group mode: Visible groups

Scenario: 41

        And I log in as "t1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group1,group2,group3)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group1,group2,group3)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group1,group2,group3)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group1,group2,group3)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group1,group2,group3)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group1,group2,group3)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group1,group2,group3)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

# Configuration details:
# Allow students to use Quickmail [global]: not set
# Allow students to use Quickmail [course]: not set
# FERPA Mode: not set
# Course group mode: Visible groups

Scenario: 42

        And I log in as "t1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group1,group2,group3)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s1"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "s4"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group1,group2,group3)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s2"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group1,group2,group3)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s3"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s5"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

# Configuration details:
# Allow students to use Quickmail [global]: not set
# Allow students to use Quickmail [course]: Yes
# FERPA Mode: No Group Respect
# Course group mode: ignored

Scenario: 43

        And I log in as "t1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

# Configuration details:
# Allow students to use Quickmail [global]: not set
# Allow students to use Quickmail [course]: not set
# FERPA Mode: No Group Respect
# Course group mode: ignored

Scenario: 44

        And I log in as "t1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s1"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "s4"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s2"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s3"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s5"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

# Configuration details:
# Allow students to use Quickmail [global]: Never
# Allow students to use Quickmail [course]: ignored
# FERPA Mode: Always Separate Groups
# Course group mode: ignored

Scenario: 45

        And I log in as "t1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group1)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1)" in the "#from_users" "css_element"
            Then I should not see "t2 teacher" in the "#from_users" "css_element"
            Then I should not see "s2 student" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            Then I should not see "group2" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "t4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s1"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "s4"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "s4 student (group2)" in the "#from_users" "css_element"
            Then I should not see "t1 teacher" in the "#from_users" "css_element"
            Then I should not see "s1 student" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s2"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should not see "t1 teacher" in the "#from_users" "css_element"
            Then I should not see "s1 student" in the "#from_users" "css_element"
            Then I should not see "s4 student" in the "#from_users" "css_element"
            Then I should not see "t2 teacher" in the "#from_users" "css_element"
            Then I should not see "s2 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group2" in the "#groups" "css_element"
        And I log out

        And I log in as "s3"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group2" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s5"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

# Configuration details:
# Allow students to use Quickmail [global]: Never
# Allow students to use Quickmail [course]: ignored
# FERPA Mode: not set
# Course group mode: not set

Scenario: 46

        And I log in as "t1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s1"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "s4"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s2"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s3"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s5"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

# Configuration details:
# Allow students to use Quickmail [global]: Never
# Allow students to use Quickmail [course]: ignored
# FERPA Mode: not set
# Course group mode: Separate groups

Scenario: 47

        And I log in as "t1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group1)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1)" in the "#from_users" "css_element"
            Then I should not see "t2 teacher" in the "#from_users" "css_element"
            Then I should not see "s2 student" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            Then I should not see "group2" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "t4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s1"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "s4"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "s4 student (group2)" in the "#from_users" "css_element"
            Then I should not see "t1 teacher" in the "#from_users" "css_element"
            Then I should not see "s1 student" in the "#from_users" "css_element"
            Then I should not see "t3 teacher" in the "#from_users" "css_element"
            Then I should not see "s3 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s2"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should not see "t1 teacher" in the "#from_users" "css_element"
            Then I should not see "s1 student" in the "#from_users" "css_element"
            Then I should not see "s4 student" in the "#from_users" "css_element"
            Then I should not see "t2 teacher" in the "#from_users" "css_element"
            Then I should not see "s2 student" in the "#from_users" "css_element"
            Then I should not see "t5 teacher" in the "#from_users" "css_element"
            Then I should not see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group2" in the "#groups" "css_element"
        And I log out

        And I log in as "s3"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            Then I should not see "group1" in the "#groups" "css_element"
            And I should not see "group2" in the "#groups" "css_element"
            And I should not see "group3" in the "#groups" "css_element"
        And I log out

        And I log in as "s5"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

# Configuration details:
# Allow students to use Quickmail [global]: Never
# Allow students to use Quickmail [course]: ignored
# FERPA Mode: not set
# Course group mode: Visible groups

Scenario: 48

        And I log in as "t1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher (group1,group2,group3)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s1"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "s4"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group1,group2,group3)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "t3 teacher (group3)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s2"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher (group1)" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher (group1,group2,group3)" in the "#from_users" "css_element"
            Then I should see "s1 student (group1)" in the "#from_users" "css_element"
            Then I should see "s4 student (group1,group2)" in the "#from_users" "css_element"
            Then I should see "t2 teacher (group2)" in the "#from_users" "css_element"
            Then I should see "s2 student (group2)" in the "#from_users" "css_element"
            Then I should see "s3 student (group3)" in the "#from_users" "css_element"
            Then I should see "t5 teacher (Not in a group)" in the "#from_users" "css_element"
            Then I should see "s5 student (Not in a group)" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s3"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s5"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

# Configuration details:
# Allow students to use Quickmail [global]: Never
# Allow students to use Quickmail [course]: ignored
# FERPA Mode: No Group Respect
# Course group mode: ignored

Scenario: 49

        And I log in as "t1"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "t4"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s1"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "s4"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t2"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "t3 teacher" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s2"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t3"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
            Then I should see "t1 teacher" in the "#from_users" "css_element"
            Then I should see "t4 editingteacher" in the "#from_users" "css_element"
            Then I should see "s1 student" in the "#from_users" "css_element"
            Then I should see "s4 student" in the "#from_users" "css_element"
            Then I should see "t2 teacher" in the "#from_users" "css_element"
            Then I should see "s2 student" in the "#from_users" "css_element"
            Then I should see "s3 student" in the "#from_users" "css_element"
            Then I should see "t5 teacher" in the "#from_users" "css_element"
            Then I should see "s5 student" in the "#from_users" "css_element"
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s3"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

        And I log in as "t5"
        And I follow "Course One"
        When I click on "Compose New Email" "link" in the "Quickmail" "block"
        Then I should see "There are no users in your group capable of being emailed."
            Then I should see "All Users" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
            And I should see "All Groups" in the "#groups" "css_element"
            And I should see "group1" in the "#groups" "css_element"
            And I should see "group2" in the "#groups" "css_element"
            And I should see "group3" in the "#groups" "css_element"
            And I should see "Not in a group" in the "#groups" "css_element"
        And I log out

        And I log in as "s5"
        And I follow "Course One"
        Then I should not see "Quickmail"
        And I log out

